/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// Pygolampis 2

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;

const int numBlobs = 128;

void main( void ) {

	vec2 p = (scaled_gl_FragCoord.xy / resolution.x) - vec2(0.5, 0.5 * (resolution.y / resolution.x));

	vec3 c = vec3(0.0);
	for (int i=0; i<numBlobs; i++)
	{
		float px = sin(float(i)*0.1 + 0.5*time) * 0.4;
		float py = sin(float(i*i)*0.01 + 0.4*time) * 0.2;
		float pz = sin(float(i*i*i)*0.001 + 0.3*time) * 0.3 + 0.4;
		float radius = 0.005 / pz;
		vec2 pos = p + vec2(px, py);
		float z = radius - length(pos);
		if (z < 0.0) z = 0.0;
		float cc = z / radius;
		c += vec3(cc * (sin(float(i*i*i)) * 0.5 + 0.5), cc * (sin(float(i*i*i*i*i)) * 0.5 + 0.5), cc * (sin(float(i*i*i*i)) * 0.5 + 0.5));
	}

	gl_FragColor = vec4(c, 1.0) + vec4(p.y, p.y, p.y, 1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}